/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.designer;

import filenet.vw.apps.designer.VWDesignerCore;
import filenet.vw.apps.designer.images.VWImageLoader;
import filenet.vw.apps.designer.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWLogger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWSplashWindowListener;
import filenet.vw.toolkit.utils.VWBaseLaunchableApplication;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplashWindow;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Dimension;
import javax.swing.ImageIcon;

public class VWDesignerApplication
extends VWBaseLaunchableApplication
implements IVWSplashWindowListener {
    public static final Dimension DIM_DEFAULT_SIZE = new Dimension(1024, 768);
    private VWDesignerCore m_designerCore = null;
    private static int m_nApplicationMode = 1;

    public static void main(String[] argv) {
        try {
            VWDebug.init(VWLogger.ERROR);
            VWCommandLineArgs args = new VWCommandLineArgs(argv);
            VWSessionInfo sessionInfo = new VWSessionInfo(null, null, args);
            String[] groups = new String[]{VWResource.s_pwDesignerGroup, VWResource.s_pwDiagramGroup};
            if (!sessionInfo.verifyLogon(groups, false)) {
                System.exit(1);
            }
            if (VWStringUtils.compare(sessionInfo.getSecurityGroupName(), VWResource.s_pwDiagramGroup) == 0) {
                m_nApplicationMode = 0;
            }
            VWDesignerApplication pApp = new VWDesignerApplication();
            pApp.init(sessionInfo);
            VWHelp.init(pApp);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWSessionInfo sessionInfo) {
        try {
            super.init(sessionInfo);
            VWSplashWindow splashWindow = new VWSplashWindow(this);
            this.setFormattedWindowTitle(VWIDMBaseFactory.instance().getVWString(5).toString());
            ImageIcon icon = VWImageLoader.createImageIcon("designer.gif");
            if (icon != null && icon.getImage() != null) {
                this.setIconImage(icon.getImage());
            }
            if (!this.updatePosition("designer_location", "designer_size")) {
                this.updatePosition(VWDesignerApplication.DIM_DEFAULT_SIZE.width, VWDesignerApplication.DIM_DEFAULT_SIZE.height);
            }
            this.setVisible(true);
            if (splashWindow != null) {
                splashWindow.start(this, 1000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void startProcessing() {
        try {
            this.m_designerCore = new VWDesignerCore();
            this.m_designerCore.init(this.m_sessionInfo, m_nApplicationMode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean destroy() {
        try {
            if (this.m_designerCore != null && !this.m_designerCore.destroy()) {
                return false;
            }
            return super.destroy();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }
}

